/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.org.bson.codecs;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.impactdev.impactor.relocations.org.bson.BsonDbPointer;
import net.impactdev.impactor.relocations.org.bson.BsonRegularExpression;
import net.impactdev.impactor.relocations.org.bson.BsonTimestamp;
import net.impactdev.impactor.relocations.org.bson.BsonType;
import net.impactdev.impactor.relocations.org.bson.BsonUndefined;
import net.impactdev.impactor.relocations.org.bson.Document;
import net.impactdev.impactor.relocations.org.bson.types.Binary;
import net.impactdev.impactor.relocations.org.bson.types.Code;
import net.impactdev.impactor.relocations.org.bson.types.CodeWithScope;
import net.impactdev.impactor.relocations.org.bson.types.Decimal128;
import net.impactdev.impactor.relocations.org.bson.types.MaxKey;
import net.impactdev.impactor.relocations.org.bson.types.MinKey;
import net.impactdev.impactor.relocations.org.bson.types.ObjectId;
import net.impactdev.impactor.relocations.org.bson.types.Symbol;

public class BsonTypeClassMap {
    private final Map<BsonType, Class<?>> map = new HashMap();

    public BsonTypeClassMap(Map<BsonType, Class<?>> replacementsForDefaults) {
        this.addDefaults();
        this.map.putAll(replacementsForDefaults);
    }

    public BsonTypeClassMap() {
        this(Collections.emptyMap());
    }

    Set<BsonType> keys() {
        return this.map.keySet();
    }

    public Class<?> get(BsonType bsonType) {
        return this.map.get((Object)bsonType);
    }

    private void addDefaults() {
        this.map.put(BsonType.ARRAY, List.class);
        this.map.put(BsonType.BINARY, Binary.class);
        this.map.put(BsonType.BOOLEAN, Boolean.class);
        this.map.put(BsonType.DATE_TIME, Date.class);
        this.map.put(BsonType.DB_POINTER, BsonDbPointer.class);
        this.map.put(BsonType.DOCUMENT, Document.class);
        this.map.put(BsonType.DOUBLE, Double.class);
        this.map.put(BsonType.INT32, Integer.class);
        this.map.put(BsonType.INT64, Long.class);
        this.map.put(BsonType.DECIMAL128, Decimal128.class);
        this.map.put(BsonType.MAX_KEY, MaxKey.class);
        this.map.put(BsonType.MIN_KEY, MinKey.class);
        this.map.put(BsonType.JAVASCRIPT, Code.class);
        this.map.put(BsonType.JAVASCRIPT_WITH_SCOPE, CodeWithScope.class);
        this.map.put(BsonType.OBJECT_ID, ObjectId.class);
        this.map.put(BsonType.REGULAR_EXPRESSION, BsonRegularExpression.class);
        this.map.put(BsonType.STRING, String.class);
        this.map.put(BsonType.SYMBOL, Symbol.class);
        this.map.put(BsonType.TIMESTAMP, BsonTimestamp.class);
        this.map.put(BsonType.UNDEFINED, BsonUndefined.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BsonTypeClassMap that = (BsonTypeClassMap)o;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }
}

